#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include "upctv.h"

#include "language.h"

#include "checkmem.h"



#define STRINGTOREAD "Tanto monta, monta tanto, Isabel como Fernando. Conversor de texto a voz desarrollado en la UPC"
#define LSPKINFO 40

 
unsigned short SetNextSpk(unsigned short spkId, int numSpk) {
   char SpkInfo[LSPKINFO];
   int retv;

   while(1) {
      spkId++;
      if (spkId == numSpk)
         spkId = 0;
      retv = upcTVSetSpeaker(spkId);
      if (retv == 0) {
         break;
      }
      if (retv < 0) {
         if (spkId == 0)
            spkId = numSpk;
         spkId--;
         break;
      }
   }
   if (retv == 0) {
      upcTVGetInfoSpeaker(spkId, SpkInfo, LSPKINFO);
      fprintf(stdout, "%s\n", SpkInfo);
   }
   return spkId;
}

      
main (int argc, char **argv) {
   char c;
   int more = 1, fileIndex = 1, ReadFromFile;
   int WordsPerMinute = 170;
   float SpeedFactor = 1.2F;

   int breakNumber = -1;


   InitCheckMem(NULL, breakNumber);
  
   
   unsigned short spkId;
   int numSpk = upcTVGetNumberOfSpeakers();

   upcTVSetLanguage    (LG_SPANISH);
   spkId = SetNextSpk  (numSpk-1, numSpk);
   upcTVSetSpeed       (WordsPerMinute);

   ReadFromFile = (argc > 1);
  
   int pause = 0;
   fprintf(stdout, 
      "Press:\n"
      "\tQ:\tquit\n"
      "\tS:\tstop\n"
      "\tP:\tplay\n"
      "\t+:\tfaster\n"
      "\t-:\tslowler\n"
      "\tX:\tpause|resume\n"
      "\tC:\tcatalan\n"
      "\tE:\tspanish\n" 
      "\tX:\tpause|resume\n"
      "\tN:\tnext speaker\n"
      "\t?:\tabout ...\n"
      "\t!:\tstatus\n"
      "\n");


   while (more) {
      c = getch();
      switch (c) {
      case 'q':
      case 'Q':
         more = 0;
         break;
      case 's':
      case 'S':
         upcTVStop();
         break;
      case 'p':
      case 'P':
         if (ReadFromFile) {
            upcTVReadFile(argv[fileIndex++]);
            if (fileIndex == argc) 
               fileIndex = 1;
         } else
            upcTVRead(STRINGTOREAD);
         break;
      case '+':
         WordsPerMinute = (int) (WordsPerMinute * SpeedFactor);
         upcTVSetSpeed   (WordsPerMinute);
         break;
      case '-':
         WordsPerMinute = (int) (WordsPerMinute / SpeedFactor);
         upcTVSetSpeed   (WordsPerMinute);
         break;
      case 'x':
      case 'X':
         pause = 1 - pause;
         if (pause)
            upcTVPause();
         else
            upcTVResume();
         break;
      case 'c':
      case 'C':
         upcTVSetLanguage(LG_CATALAN);
         break;
      case 'e':
      case 'E':
         upcTVSetLanguage(LG_SPANISH);
         break;
      case 'n':
      case 'N':
         spkId = SetNextSpk(spkId, numSpk);
         break;
      case '?':
         upcTVAbout();
         break;
      case '!':
         int status = upcTVStatus(100);
         switch (status) {
         case TV_INACTIVE:
            fprintf(stderr, "Inactive\n");
            break;
         case TV_PAUSED:
            fprintf(stderr, "Paused\n");
            break;
         case TV_PLAYING:
            fprintf(stderr, "Playing\n");
            break;
         case TV_ERROR:
            fprintf(stderr, "Error\n");
            break;
         }
         break;
      }
   }

   return 0;
}
